### 16.9. Can I regenerate the structure from InChI? 

*Yes* - if you have the program output produced with "Full auxiliary information" option, AuxInfo. 

The AuxInfo string is a valid input for InChI Software which should be enough for regenerating the parent structure. In particular, it holds atomic coordinates which are not contained in InChI itself.

*Yes, with some significant limitations* - if you have just an InChI. 

First, as the InChI contains no atomic coordinates, the best result will be only the coordinate-less “0D” structure. Among other things, this means problems with restoring stereochemistry.

Second, if the InChI has been created with some layers omitted, the corresponding structural details may not be restored, evidently. For example, as Standard InChI lacks reconnected metal and fixed-hydrogen layers, neither bonds to metals nor precise positions of mobile H atoms  may be regenerated from a Standard InChI.

The InChI API library has a dedicated function GetStructFromINCHI() intended for restoring the structure from InChI (but not from InChIKey, as it is a hashed form of InChI which could not be directly decrypted). 

Software vendors have already complemented the InChI library with their own procedures for generating atomic coordinates and built the functionality 'Generate structure from InChI string' into their products. Examples (there are probably more) are Accelrys Draw, Perkin-Elmer (formerly CambridgeSoft) ChemDraw, and ACD/Labs ChemSketch.